### 软件用途

本软件用于跨平台连接多种数据库，和对数据库中的表和数据进行建模和查询，并提供接口让其他服务使用其功能。

下载：🧷**[数据库后台服务部署手册](https://resource.helplook.net/docker_production/3648ne/article/ntSaMmaZ/attachments/%E6%95%B0%E6%8D%AE%E5%BA%93%E5%90%8E%E5%8F%B0%E6%9C%8D%E5%8A%A1%E9%83%A8%E7%BD%B2%E6%89%8B%E5%86%8C.zip "数据库后台服务部署手册.zip")**

---

### 环境依赖

由于本软件采用跨平台的.NetCore6.0开发框架，所以可以支持多种系统(Linux+Windwos)，但需要预先安装. Net 6才能运行。

---

### 部署步骤（以下基于Linux系统）

3.1 在Ubuntu上安装.Net6运行时，如已部署请忽略

\#注意此命令中20.04为Ubuntu系统版本，如果系统为Ubuntu XX，则在命令中改为XX

wget https://packages.microsoft.com/config/ubuntu/20.04/packages-microsoft-prod.deb -O packages-microsoft-prod.deb

sudo dpkg -i packages-microsoft-prod.deb

rm packages-microsoft-prod.deb

sudo apt-get update

sudo apt-get install -y dotnet-sdk-6.0

sudo apt-get update

sudo apt-get install -y aspnetcore-runtime-6.0

sudo apt-get install -y dotnet-runtime-6.0

\#执行完以上命令后可执行以下命令来检查安装是否成功

dotnet --info

3.2 在Debian上安装.Net6运行时，如已部署请忽略

\#注意此命令中12为Debian系统版本，如果系统为Debian 11，则在命令中改为11

wget https://packages.microsoft.com/config/debian/12/packages-microsoft-prod.deb -O packages-microsoft-prod.deb

sudo dpkg -i packages-microsoft-prod.deb

rm packages-microsoft-prod.deb

sudo apt-get update

sudo apt-get install -y dotnet-sdk-6.0

sudo apt-get update

sudo apt-get install -y aspnetcore-runtime-6.0

sudo apt-get install -y dotnet-runtime-6.0

\#执行完以上命令后可执行以下命令来检查安装是否成功

dotnet --info

3.3 部署服务程序

跳转到/home/sinsegye/，创建文件夹dbservice，执行如下命令

sudo chmod 777 dbservice

sudo chown 777 dbservice

解压数据库服务程序包到目标机器上，如cd /home/sinsegye/dbservice

3.4 修改程序包中的dbservice.service文件，其中黄色部分路径需修改为部署路径

\[Unit\]

Description=Sinsegye RTE service

\[Service\]

\# CPUWeight=10000

CPUAffinity=0

\# Nice=-20

\# CPUSchedulingPolicy=rr

\# CPUSchedulingPriority=99

WorkingDirectory=/home/sinsegye/dbservice

ExecStart=/usr/share/dotnet/dotnet /home/sinsegye/dbservice/Sinsegye.DBService.dll

KillMode=mixed

TimeoutStopSec=8s

Restart=always

RestartSec=60s

Type=simple

\[Install\]

WantedBy=multi-user.target

Alias=dbservice.service

3.5 转到/usr/lib/systemd/目录，并执行命令：

sudo chmod 777 system

sudo chown 777 system

3.6 移动或复制dbservice.service到/usr/lib/systemd/system/dbservice.service

3.7 安装服务：sudo systemctl daemon-reload

3.8 启用服务：sudo systemctl enable dbservice

3.9 启动服务：sudo systemctl start dbservice

3.10 查看服务状态：sudo systemctl status dbservice

3.11 重启服务：sudo systemctl restart dbservice

4 配置说明（appsetings.json）

4.1 GrpcPort：服务调用的端口号，默认为50001，修改后重启服务生效